"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getArpIpByMac = exports.getArpMacByIp = exports.getArpTable = void 0;
/*
 * @Author: renxia
 * @Date: 2023-12-08 09:31:39
 * @LastEditors: renxia
 * @LastEditTime: 2023-12-08 11:58:38
 * @Description:
 */
const child_process_1 = require("child_process");
const net_1 = require("net");
const process_1 = __importDefault(require("process"));
const utils_1 = require("./utils");
const getNetworkInteraces_1 = require("./getNetworkInteraces");
async function getArpTable(stdout = '') {
    const isWindows = process_1.default.platform === 'win32';
    if (!stdout) {
        if (isWindows) {
            const { default: iconv } = await Promise.resolve().then(() => __importStar(require('iconv-lite')));
            stdout = iconv.decode((0, child_process_1.execSync)('arp -a', { windowsHide: true }), 'gbk').trim();
        }
        else {
            stdout = (0, child_process_1.execSync)('arp -an', { windowsHide: true }).toString('utf8').trim();
        }
    }
    const table = [];
    let iip = '';
    let iface = '';
    for (const line of stdout.split('\n').map(d => d.trim())) {
        if (!line)
            continue;
        let ip = '';
        let mac = '';
        let type = 'unknown';
        if (isWindows) {
            [ip, mac, type = 'unknown'] = line.split(/\s+/);
            if ((0, net_1.isIP)(mac)) {
                iip = mac;
                continue;
            }
            if (type.includes('动态'))
                type = 'dynamic';
            else if (type.includes('静态'))
                type = 'static';
        }
        else {
            const match = line.match(/\(([\d.]+)\) at (\S+) .*on ([\da-z]+)/);
            if (!match)
                continue;
            const preIface = iface;
            [, ip, mac, iface] = match;
            if (preIface !== iface) {
                const item = await (0, getNetworkInteraces_1.getNetworkIFaceOne)(iface);
                if (item)
                    iip = item.address;
            }
        }
        if ((0, net_1.isIP)(ip)) {
            table.push({ iip, ip, mac: (0, utils_1.formatMac)(mac), type: (type || 'unknown') });
        }
    }
    return { stdout, table };
}
exports.getArpTable = getArpTable;
async function getArpMacByIp(ip) {
    if (!ip)
        return '';
    const { table } = await getArpTable();
    const item = table.find(d => d.ip === ip);
    return item ? item.mac : '';
}
exports.getArpMacByIp = getArpMacByIp;
async function getArpIpByMac(mac) {
    mac = (0, utils_1.formatMac)(mac);
    if (!mac)
        return [];
    const { table } = await getArpTable();
    return table.filter(d => d.mac.includes(mac)).map(d => d.ip);
}
exports.getArpIpByMac = getArpIpByMac;
// getArpTable().then(d => console.log(d.table));
