"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getNetworkIFacesInfoByWmic = void 0;
const child_process_1 = require("child_process");
const process_1 = __importDefault(require("process"));
const utils_1 = require("./utils");
function execPromisfy(cmd, options = {}, trimEmptyLine = false) {
    return new Promise(resolve => {
        (0, child_process_1.exec)(cmd, { windowsHide: true, ...options }, (error, stdout, stderr) => {
            if (error)
                console.error('exec error:', `cmd: ${cmd}\n`, error.message || error);
            stdout = stdout.replace(/\r+\n/g, '\n').trim();
            if (trimEmptyLine)
                stdout = stdout.replace(/\n{2,}/g, '\n');
            resolve({ error, stdout, stderr });
        });
    });
}
async function getNetworkIFacesInfoByWmic() {
    const config = {};
    let stdout = '';
    if (process_1.default.platform === 'win32') {
        const keyMap = { MACAddress: 'mac', Description: 'desc' };
        const cmd = `wmic nic get MACAddress,Description /format:list`;
        const info = await execPromisfy(cmd);
        const lines = info.stdout.split('\n').filter(d => d.includes('='));
        stdout = info.stdout;
        if (lines[0]) {
            let item = {};
            const setToConfig = () => {
                if (item.mac) {
                    item.mac = (0, utils_1.formatMac)(item.mac);
                    if (!config[item.mac] || !(0, utils_1.isVirtualMac)('', item.desc))
                        config[item.mac] = item;
                }
                item = {};
            };
            for (const line of lines) {
                let [key, value] = line.split('=').map(d => d.trim());
                key = keyMap[key] || key.toLowerCase();
                if (item[key])
                    setToConfig();
                item[key] = value;
            }
            setToConfig();
        }
        if (stdout)
            (0, utils_1.logDebug)(`[getNetworkIFacesInfoByWmic]`, stdout, config);
    }
    return { stdout, config };
}
exports.getNetworkIFacesInfoByWmic = getNetworkIFacesInfoByWmic;
