"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getMac = exports.getAllPhysicsMac = exports.getAllMac = void 0;
const getNetworkInteraces_1 = require("./getNetworkInteraces");
const utils_1 = require("./utils");
function getAllMac() {
    const list = (0, getNetworkInteraces_1.getAllNetworkIFaces)();
    const macSet = new Set();
    for (const item of list) {
        if (!item.internal && !(0, utils_1.isZeroMac)(item.mac))
            macSet.add(item.mac);
    }
    return [...macSet];
}
exports.getAllMac = getAllMac;
function getAllPhysicsMac(family) {
    return (0, getNetworkInteraces_1.getNetworkIFaces)('', family).then(d => {
        d = d.filter(m => !(0, utils_1.isVirtualMac)(m.mac, m.desc));
        return [...new Set(d.map(m => m.mac))];
    });
}
exports.getAllPhysicsMac = getAllPhysicsMac;
function getMac(iface) {
    return (0, getNetworkInteraces_1.getNetworkIFaceOne)(iface).then(item => item === null || item === void 0 ? void 0 : item.mac);
}
exports.getMac = getMac;
