"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getNetworkIFaceOne = exports.getNetworkIFaces = exports.getAllNetworkIFaces = void 0;
const os_1 = require("os");
const getIFacesByExec_1 = require("./getIFacesByExec");
const utils_1 = require("./utils");
/** sort by: !internal > !zeroMac(mac) > desc for visual > family=IPv4 */
function ifacesSort(list) {
    return list.sort((a, b) => {
        if (a.internal !== b.internal)
            return a.internal ? 1 : -1;
        if ((0, utils_1.isZeroMac)(a.mac) !== (0, utils_1.isZeroMac)(b.mac))
            return (0, utils_1.isZeroMac)(a.mac) ? 1 : -1;
        const isVirtualA = (0, utils_1.isVirtualMac)(a.mac);
        const isVirtualB = (0, utils_1.isVirtualMac)(b.mac);
        if (isVirtualA !== isVirtualB)
            return isVirtualA ? 1 : -1;
        if (!a.address || !b.address)
            return a.address ? -1 : 1;
        if (a.family !== b.family)
            return a.family === 'IPv6' ? 1 : -1;
    });
}
function getNif() {
    const nif = (0, os_1.networkInterfaces)();
    for (const key in nif) {
        if (key.includes('以太网')) {
            nif[key.replace('以太网', 'ethernet')] = nif[key];
            delete nif[key];
        }
    }
    return nif;
}
/** get all networkInterfaces and sort by some rules */
function getAllNetworkIFaces() {
    const nif = getNif();
    const list = [];
    // en0 - mac, eth3 - linux, ethernet - windows
    const highPriorityIfaces = /^((en|eth)\d+|ethernet)$/i;
    const lowPriorityIfaces = /^((lo|vboxnet)\d+)$/i;
    const ifaces = Object.keys(nif).sort((a, b) => {
        if (highPriorityIfaces.test(a)) {
            if (highPriorityIfaces.test(b))
                return a.localeCompare(b);
            return -1;
        }
        if (lowPriorityIfaces.test(a)) {
            if (lowPriorityIfaces.test(b))
                return a.localeCompare(b);
            return 1;
        }
        if (highPriorityIfaces.test(b))
            return 1;
        if (lowPriorityIfaces.test(b))
            return -1;
        return a.localeCompare(b);
    });
    for (const key of ifaces) {
        for (const item of nif[key])
            list.push(item);
    }
    return ifacesSort(list);
}
exports.getAllNetworkIFaces = getAllNetworkIFaces;
async function getNetworkIFaces(iface, family) {
    let list = [];
    if (iface) {
        const nif = getNif();
        if (nif[iface]) {
            list = nif[iface];
            if (family)
                list = list.filter(d => d.family === family);
            if (list.length > 1)
                list = list.filter(d => !(0, utils_1.isZeroMac)(d.mac));
        }
        return ifacesSort(list);
    }
    list = getAllNetworkIFaces().filter(item => !(0, utils_1.isZeroMac)(item.mac) && (!family || item.family === family));
    // if (hasMutiMac(list)) list = list.filter(d => d.address);
    // if (hasMutiMac(list)) list = list.filter(d => !isVirtualMac(d.mac));
    // filter by desc for windows
    if ((0, utils_1.hasMutiMac)(list) && process.platform === 'win32') {
        const info = await (0, getIFacesByExec_1.getNetworkIFacesInfoByWmic)(); // await getNetworkIFacesInfoByIpconfig();
        if (info.stdout) {
            const r = list.filter(item => {
                if (!info.config[item.mac])
                    return true;
                const desc = info.config[item.mac].desc;
                item.desc = desc;
                return !(0, utils_1.isVirtualMac)('', desc);
            });
            if (r.length > 0)
                list = r;
        }
    }
    (0, utils_1.logDebug)('[getNetworkIFaces]', list);
    return list;
}
exports.getNetworkIFaces = getNetworkIFaces;
function getNetworkIFaceOne(iface) {
    return getNetworkIFaces(iface).then(list => list[0]);
}
exports.getNetworkIFaceOne = getNetworkIFaceOne;
