"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.hasMutiMac = exports.formatMac = exports.isValidMac = exports.isVirtualMac = exports.isZeroMac = exports.hasMac = exports.isMac = exports.logDebug = exports.isDebug = void 0;
function isDebug() {
    return process.env.DEBUG === '*' || process.env.DEBUG === 'GPMA' || process.env.GPA_DEBUG === '1';
}
exports.isDebug = isDebug;
function logDebug(...argument) {
    var _a;
    if (!isDebug())
        return;
    if ((_a = globalThis.logger) === null || _a === void 0 ? void 0 : _a.debug)
        globalThis.logger.debug(...argument);
    else
        console.debug(...argument);
}
exports.logDebug = logDebug;
function isMac(mac) {
    return /^([\da-f]{1,2}[:-]){5}([\da-f]{1,2})$/i.test(mac);
}
exports.isMac = isMac;
function hasMac(content) {
    return /([\da-f]{1,2}[:-]){5}([\da-f]{1,2})/gi.test(content);
}
exports.hasMac = hasMac;
function isZeroMac(mac) {
    return /^(0{1,2}[:-]){5}0{1,2}$/.test(mac);
}
exports.isZeroMac = isZeroMac;
const invalidMacAddresses = new Set(['00:00:00:00:00:00', 'ff:ff:ff:ff:ff:ff', 'ac:de:48:00:11:22']);
// see https://standards-oui.ieee.org/oui/oui.txt
const virtualMacPrefix = new Set([
    '00:05:69', // vmware1
    '00:0c:29', // vmware2
    '00:50:56', // vmware3
    '00:1c:14', // vmware
    '00:1c:42', // parallels1
    '02:00:4c', // Microsoft Loopback Adapter (微软回环网卡)
    '00:03:ff', // microsoft virtual pc
    '00:0f:4b', // virtual iron 4
    '00:16:3e', // red hat xen , oracle vm , xen source, novell xen
    '08:00:27', // virtualbox
    '0a:00:27', // virtualbox
    '00:ff:78', // Sangfor
    '00:ff:9d', // Sangfor
]);
function isVirtualMac(mac, desc) {
    let isVirtual = false;
    if (mac) {
        isVirtual = isMac(mac) && virtualMacPrefix.has(formatMac(mac).slice(0, 8));
    }
    if (desc && !isVirtual) {
        const virtualDescList = [
            'virtual',
            ' vpn ',
            ' ssl ',
            'tap-windows',
            'hyper-v',
            'vEthernet', // vEthernet (Default Switch)
            'km-test',
            'microsoft loopback',
            'sangfor ',
        ];
        desc = String(desc).toLowerCase();
        isVirtual = virtualDescList.some(d => desc.includes(d));
    }
    return isVirtual;
}
exports.isVirtualMac = isVirtualMac;
function isValidMac(mac) {
    return !invalidMacAddresses.has(formatMac(mac)) && isMac(mac);
}
exports.isValidMac = isValidMac;
function formatMac(mac) {
    return String(mac).trim().toLowerCase().replace(/-/g, ':');
}
exports.formatMac = formatMac;
function hasMutiMac(list, filter) {
    if (!list || list.length === 0)
        return false;
    if (typeof filter !== 'function')
        filter = isMac;
    return new Set(list.map(d => d.mac).filter(mac => filter(mac))).size > 1;
}
exports.hasMutiMac = hasMutiMac;
